<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Planeamiento y Presupuesto de la Universidad Nacional de San Mart&iacute;n - UNSM">
    <meta name="keywords" content="UNSM, Planeamiento, Presupuesto, Universidad San Mart&iacute;n">
    <meta name="author" content="Universidad Nacional de San Mart&iacute;n">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Planeamiento y Presupuesto - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../css/style.css">
    <!-- Stylesheet Planeamiento y Presupuesto -->
    <link rel="stylesheet" href="css/stylePlanea.css">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en Facebook" aria-label="P&aacute;gina oficial de Facebook de la UNSM">
                    <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="S&iacute;guenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../imagenes/logo telefono.png" alt="Tel&eacute;fono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 48 0153</span>
                </span>
                <span>
                    <img src="../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>informes@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../" aria-label="Ir a la p&aacute;gina principal de UNSM">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Mart&iacute;n" width="auto" height="70">
                </a>
            </div>

            <!-- Bot&oacute;n Hamburguesa para m&oacute;vil -->
            <button class="mobile-menu-toggle" aria-label="Abrir men&uacute; de navegaci&oacute;n" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegaci&oacute;n principal">
                <div class="mobile-nav-logo">
                    <img src="../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="../../#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Nosotros">
                            <li><a href="../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../nosotros/mision/indexMision.php">Nuestra Misi&oacute;n y Visi&oacute;n</a></li>
                            <li><a href="../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../nosotros/calendarioAcade/indexCale.php">Calendario Acad&eacute;mico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="../../#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Men&uacute; Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../vicerrectorado academico/indexVicerec.php">Vicerrectorado Acad&eacute;mico</a></li>
                                <li><a href="../vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigaci&oacute;n</a></li>
                                <li><a href="../secretaria general/indexSecreGene.php">Secretar&iacute;a General</a></li>
                                <li><a href="./">Planeamiento y Presupuesto</a></li>
                                <li><a href="../seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../comunicacion y imagen institucional/indexImagen.php">Comunicaci&oacute;n e Imagen Institucional</a></li>
                                <li><a href="../Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperaci&oacute;n y Relaciones Internacionales</a></li>
                                <li><a href="../Organo de Control Institucional/indexOrgaConIns.php">&Oacute;rgano de Control Institucional</a></li>
                                <li><a href="../Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../Asesoria Juridica/indexAseJuri.php">Asesor&iacute;a Jur&iacute;dica</a></li>
                                <li><a href="../Grados y Titulos/indexGrados.php">Grados y T&iacute;tulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Acad&eacute;micas</li>
                                <li><a href="../../#admision">Oficina de Admisi&oacute;n</a></li>
                                <li><a href="../../#asuntos-academicos">Asuntos Acad&eacute;micos</a></li>
                                <li><a href="../../#seguimiento">Seguimiento al Egresado e Inserci&oacute;n Laboral</a></li>
                                <li><a href="../../#tecnologias">Tecnolog&iacute;as de la Informaci&oacute;n</a></li>
                                <li><a href="../../#incubadora">Incubadora de Empresas</a></li>
                                <li><a href="../../#fondo-editorial">Fondo Editorial</a></li>
                                <li><a href="../../#comite-electoral">Comit&eacute; Electoral Universitario</a></li>
                                <li><a href="../../#innovacion">Innovaci&oacute;n y Transferencia Tecnol&oacute;gica</a></li>
                                <li><a href="../../#produccion">Producci&oacute;n de Bienes y Servicios</a></li>
                                <li><a href="../../#responsabilidad">Responsabilidad Social Universitaria</a></li>
                                <li><a href="../../#servicios-generales">Servicios Generales</a></li>
                                <li><a href="../../#bienestar">Bienestar Universitario</a></li>
                                <li><a href="../../#defensoria">Defensor&iacute;a Universitaria</a></li>
                                <li><a href="../../#calidad">Gesti&oacute;n de la Calidad</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../#admision">ADMISI&Oacute;N</a></li>
                    <li><a href="../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Facultades">
                            <li class="has-submenu">
                                <a href="../../#ciencias-agrarias" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../#agronomia">Agronom&iacute;a</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-salud" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../#obstetricia">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-veterinaria" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../#medicina-veterinaria-carrera">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-agroindustrial" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a Agroindustrial">
                                    <li><a href="../../#ing-agroindustrial">Ingenier&iacute;a Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-civil" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a Civil y Arquitectura">
                                    <li><a href="../../#arquitectura">Arquitectura</a></li>
                                    <li><a href="../../#ingenieria-civil-carrera">Ingenier&iacute;a Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ingenieria-sistemas" aria-haspopup="true" aria-expanded="false">Ingenier&iacute;a de Sistemas e Inform&aacute;tica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenier&iacute;a de Sistemas">
                                    <li><a href="../../#ing-sistemas">Ingenier&iacute;a de Sistemas e Inform&aacute;tica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ecologia" aria-haspopup="true" aria-expanded="false">Ecolog&iacute;a</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecolog&iacute;a">
                                    <li><a href="../../#ing-ambiental">Ingenier&iacute;a Ambiental</a></li>
                                    <li><a href="../../#ing-sanitaria">Ingenier&iacute;a Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#derecho" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Pol&iacute;ticas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="../../#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#medicina-humana" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="../../#medicina-humana-carrera">Medicina Humana</a></li>
                                    <li><a href="../../#enfermeria">Enfermer&iacute;a</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#ciencias-economicas" aria-haspopup="true" aria-expanded="false">Ciencias Econ&oacute;micas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Econ&oacute;micas">
                                    <li><a href="../../#administracion">Administraci&oacute;n</a></li>
                                    <li><a href="../../#contabilidad">Contabilidad</a></li>
                                    <li><a href="../../#economia">Econom&iacute;a</a></li>
                                    <li><a href="../../#turismo">Turismo</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../#educacion" aria-haspopup="true" aria-expanded="false">Educaci&oacute;n y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educaci&oacute;n">
                                    <li><a href="../../#educacion-inicial">Educaci&oacute;n Inicial</a></li>
                                    <li><a href="../../#educacion-primaria">Educaci&oacute;n Primaria</a></li>
                                    <li><a href="../../#educacion-secundaria">Educaci&oacute;n Secundaria</a></li>
                                    <li><a href="../../#idiomas">Idiomas</a></li>
                                    <li>
                                        <a href="../../#psicologia">
                                            Psicolog&iacute;a
                                            <span class="badge-nuevo">Nuevo</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../#posgrado">POSGRADO</a></li>
                    <li class="dropdown">
                        <a href="../../#transparencia" aria-haspopup="true" aria-expanded="false">TRANSPARENCIA</a>
                        <ul class="dropdown-menu" aria-label="Men&uacute; Transparencia">
                            <li><a href="../../#licenciamiento">Licenciamiento</a></li>
                            <li><a href="../../#institucional">Institucional Ley 30220</a></li>
                            <li><a href="../../#estandar">Est&aacute;ndar Ley 27806</a></li>
                        </ul>
                    </li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Per&uacute;">
                        <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Per&uacute;" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Per&uacute;">
                    <img src="../../imagenes/logo gobPe.png" alt="Gobierno del Per&uacute;" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Planeamiento y Presupuesto -->
    <section class="planeamiento-banner">
        <div class="banner-container">
            <h1>PLANEAMIENTO Y PRESUPUESTO</h1>
            <div class="banner-contact">
                <p><strong>&#127970; Local Central: Jr. Maynas N&deg; 177, Tarapoto, Per&uacute;</strong></p>
                <p>&#9993; planificacion@unsm.edu.pe</p>
            </div>
        </div>
    </section>

    <!-- Contenido Principal -->
    <main class="planeamiento-main">
        <div class="planeamiento-container">
            <!-- Sidebar con tabs -->
            <aside class="planeamiento-sidebar">
                <nav class="tabs-menu">
                    <button class="tab-button active" data-tab="funciones">
                        <span class="tab-icon">&#10067;</span>
                        <span class="tab-text">FUNCIONES</span>
                    </button>
                    <button class="tab-button" data-tab="mision">
                        <span class="tab-icon">&#127919;</span>
                        <span class="tab-text">MISI&Oacute;N</span>
                    </button>
                    <button class="tab-button" data-tab="vision">
                        <span class="tab-icon">&#128065;</span>
                        <span class="tab-text">VISI&Oacute;N</span>
                    </button>
                    <button class="tab-button" data-tab="personal">
                        <span class="tab-icon">&#128100;</span>
                        <span class="tab-text">PERSONAL</span>
                    </button>
                    <button class="tab-button" data-tab="documentos">
                        <span class="tab-icon">&#128194;</span>
                        <span class="tab-text">DOCUMENTOS DE GESTI&Oacute;N</span>
                    </button>
                </nav>
            </aside>

            <!-- Contenido principal -->
            <div class="planeamiento-content">
                <!-- Tab de Funciones -->
                <div class="tab-content active" id="funciones">
                    <div class="content-wrapper">
                        <div class="funciones-section">
                            <h2>FUNCIONES</h2>
                            <ul class="funciones-list">
                                <li>Asesorar a la Alta Direcci&oacute;n y &oacute;rganos de la universidad en materia de planeamiento estrat&eacute;gico, proceso presupuestario y modernizaci&oacute;n institucional.</li>
                                <li>Conducir las fases del proceso presupuestario de la universidad.</li>
                                <li>Conducir la formulaci&oacute;n y evaluaci&oacute;n del Plan Estrat&eacute;gico Institucional, Plan Operativo Institucional y procesos de modernizaci&oacute;n, en coordinaci&oacute;n con los diferentes &oacute;rganos de la Instituci&oacute;n.</li>
                                <li>Conducir el proceso de simplificaci&oacute;n administrativa de la universidad, en coordinaci&oacute;n con los &oacute;rganos pertinentes.</li>
                                <li>Coordinar los procesos de formulaci&oacute;n de los documentos e instrumentos de gesti&oacute;n institucionales.</li>
                                <li>Participar en las fases del ciclo de inversi&oacute;n, seg&uacute;n corresponda.</li>
                                <li>Proponer directivas para la implementaci&oacute;n de los sistemas de planeamiento estrat&eacute;gico, presupuesto e inversi&oacute;n p&uacute;blica y modernizaci&oacute;n.</li>
                                <li>Emitir opini&oacute;n t&eacute;cnica en materia de su competencia.</li>
                                <li>Las dem&aacute;s funciones que asigne el Rectorado de la Universidad.</li>
                            </ul>
                        </div>

                        <div class="agenda-section">
                            <h3 class="agenda-title">Agenda Rector</h3>
                            <div class="agenda-content">
                                <p class="no-eventos">No hay nuevos eventos</p>
                                <div class="calendario-link">
                                    <a href="#">&#128467; A&ntilde;adir &#9654; Ver Calendario &#9654;</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab de Misi&oacute;n -->
                <div class="tab-content" id="mision">
                    <div class="content-wrapper">
                        <h2>MISI&Oacute;N</h2>
                        <p>Informaci&oacute;n de la misi&oacute;n de Planeamiento y Presupuesto.</p>
                    </div>
                </div>

                <!-- Tab de Visi&oacute;n -->
                <div class="tab-content" id="vision">
                    <div class="content-wrapper">
                        <h2>VISI&Oacute;N</h2>
                        <p>Informaci&oacute;n de la visi&oacute;n de Planeamiento y Presupuesto.</p>
                    </div>
                </div>

                <!-- Tab de Personal -->
                <div class="tab-content" id="personal">
                    <div class="content-wrapper">
                        <h2>PERSONAL</h2>
                        <p>Informaci&oacute;n del personal de Planeamiento y Presupuesto.</p>
                    </div>
                </div>

                <!-- Tab de Documentos -->
                <div class="tab-content" id="documentos">
                    <div class="content-wrapper">
                        <h2>DOCUMENTOS DE GESTI&Oacute;N</h2>
                        <p>Documentos de gesti&oacute;n de Planeamiento y Presupuesto.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios aut&oacute;nomo y de car&aacute;cter estatal, comprometido con la formaci&oacute;n de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N&deg; 177 - Morales</p>
                    <p>Tarapoto - San Mart&iacute;n - Per&uacute;</p>
                    <p>Central Telef&oacute;nica: <span>(+51) (042) 48 0159</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces R&aacute;pidos</h3>
                <ul class="footer-links">
                    <li><a href="../../#admision">Admisi&oacute;n</a></li>
                    <li><a href="../../#facultades">Facultades</a></li>
                    <li><a href="../../#posgrado">Posgrado</a></li>
                    <li><a href="../../#investigacion">Investigaci&oacute;n</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Mart&iacute;n - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Mart&iacute;n. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">S&iacute;guenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <script src="../../js/script.js" defer></script>
    <script src="js/scriptPlanea.js" defer></script>
    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>
</body>
</html>
